"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../../components/footer'
import Header from '../../components/header'
import '../../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../../components/loader';
import Head from 'next/head'



const Home = ()=>{
    const [load,setLoad]=useState(false)
    const [data,setData]=useState()
    const [loaded,setLoaded]= useState(false)

const params = useParams()
async function getData(qr) {
  if (params?.qr) {
    console.log(params.qr);
    const dataResponse = await axios.get('https://pixelfcty.com/api/documents?filters[slug][$eq]='+params.qr)
    const data = dataResponse.data.data[0]
    setData(data)
  }
}
  useEffect(() => { 
    getData(params)
    setLoad(true)
    setTimeout(() => {
      setLoaded(true)
    }, 1000);
  }, [params])

  return (
    <>
            <Head>
      <title>Aljaber Holding |  Qr Check</title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
      {/* <Header iswhite={false} /> */}
      <Link className="mt-10 logoInQr" href="/"><img className='img-center mt-10 px-3  logo-menu'  src={'/logo2.png'} alt='logo'></img></Link>

      <div className="container-fluid p-0 mt-10">
        <div className="row ">
            {load?
                data?
                <div className="col-sm-12 confirm" >
                <img src="/tick.webp" alt="" />
                <h1>confirm</h1>
                <p>{data.attributes.description?parse(data.attributes.description):''}</p>
          </div>:
                    <div className="col-sm-12 confirm " >
                    <img src="/x.png" alt="" />
                    <h1>not Confirm</h1>
              </div>:
               <div className="col-sm-12 confirm " >
               <h1>Loading....</h1>
         </div>
            }

        </div>
      </div>
          <Footer/>
    </main>
        }
        </>
  )
}




export default Home;